#include "precompiled.h"
#include "FileImporter.h"
#include "common.h"

namespace RTCam {

FileImporter::FileImporter(void)
{
}


FileImporter::~FileImporter(void)
{
}

string FileImporter::GetFilePath(_In_ const COMDLG_FILTERSPEC* fileTypes, size_t numFileTypes)
{
	string filepath = "";

	try {
		// Create the file-open dialog COM object.
		ComPtr<IFileDialog> fileDialog;
		ThrowIfFailed(
			CoCreateInstance(CLSID_FileOpenDialog, 
			nullptr, 
			CLSCTX_INPROC_SERVER,
			IID_PPV_ARGS(&fileDialog))
			);

		// Set the options on the dialog.
		DWORD dialogOptions;

		// Before setting, get the options first to prevent overriding existing options.
		ThrowIfFailed(fileDialog->GetOptions(&dialogOptions));

		// In this case, get shell items only for file system items.
		ThrowIfFailed(fileDialog->SetOptions(dialogOptions | FOS_FORCEFILESYSTEM));

		// Set the file types to display only. 
		// Note: This is a 1-based array.
		ThrowIfFailed(fileDialog->SetFileTypes(numFileTypes, fileTypes));

		// Set the selected file type index to the first entry.
		ThrowIfFailed(fileDialog->SetFileTypeIndex(1));

		// Set the default extension to be the first entry's extension.
		ThrowIfFailed(fileDialog->SetDefaultExtension(fileTypes[0].pszSpec));

		// Show the dialog
		HRESULT hr = fileDialog->Show(nullptr);

		if(SUCCEEDED(hr)) {
			// Obtain the result once the user clicks the 'Open' button.
			// The result is an IShellItem object.
			ComPtr<IShellItem> shellItem;
			ThrowIfFailed(fileDialog->GetResult(&shellItem));

			// Retrieve the file's path.
			PWSTR pFilepath = NULL;
			hr = shellItem->GetDisplayName(SIGDN_FILESYSPATH, &pFilepath);

			if (SUCCEEDED(hr))
			{
				filepath = Utf16ToUtf8(pFilepath);
				CoTaskMemFree(pFilepath);
			}
		}

	} catch(std::exception e) {
		// Do nothing extra for now.
		DebugPrint("Exception in OpenScene(): %s\n", e.what());
	}

	return filepath;
}

string FileImporter::GetLine(std::ifstream& filestream)
{
	string output;

	// read lines, skipping whitespace
	do {
		// stop if end of file has been reached
		if(filestream.eof()) {
			return "";
		} else {
			getline(filestream, output);
		}
	} while(IsWhitespace(output));
	
	// Remove trailing whitespace
	string whitespaces (" \t\f\v\n\r");
	size_t found = output.find_last_not_of(whitespaces);
	if (found != std::string::npos)
		output.erase(found+1);
	else
		output.clear(); // string is all whitespace

	return output;
}

} // end namespace